<!-- views/faturas/cadastrar.php -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Fatura</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</head>
<body class="bg-gray-100 font-sans">
    <nav class="bg-blue-600 p-4 text-white flex justify-between">
        <h1 class="text-lg font-bold">Sistema de Gestão</h1>
        <div>
            <a href="/public/index.php?page=clientes" class="mr-4"><i class="fas fa-users"></i> Clientes</a>
            <a href="/public/index.php?page=os" class="mr-4"><i class="fas fa-tools"></i> Ordens de Serviço</a>
            <a href="/public/index.php?page=faturas"><i class="fas fa-file-invoice"></i> Faturas</a>
        </div>
    </nav>
    <div class="container mx-auto p-6">
        <h2 class="text-2xl font-semibold mb-6">Cadastrar Fatura</h2>
        <form method="POST" class="bg-white p-6 rounded-lg shadow">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Número Fatura</label>
                    <input type="text" name="numero_fatura" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Cliente</label>
                    <select name="cliente_id" class="w-full p-2 border rounded" required>
                        <?php foreach ($clientes as $cliente): ?>
                            <option value="<?php echo $cliente['id']; ?>"><?php echo $cliente['nome']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700">Ordem de Serviço (opcional)</label>
                    <select name="os_id" class="w-full p-2 border rounded">
                        <option value="">Nenhuma</option>
                        <?php foreach ($ordens as $ordem): ?>
                            <option value="<?php echo $ordem['id']; ?>"><?php echo $ordem['numero_os']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700">Data de Emissão</label>
                    <input type="date" name="data_emissao" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Data de Vencimento</label>
                    <input type="date" name="data_vencimento" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Status</label>
                    <select name="status" class="w-full p-2 border rounded">
                        <option value="Pendente">Pendente</option>
                        <option value="Pago">Pago</option>
                        <option value="Vencido">Vencido</option>
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700">Valor</label>
                    <input type="number" step="0.01" name="valor" class="w-full p-2 border rounded" required>
                </div>
                <div>
                    <label class="block text-gray-700">Referência</label>
                    <input type="text" name="referencia" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="block text-gray-700">Período</label>
                    <input type="text" name="periodo" class="w-full p-2 border rounded">
                </div>
            </div>
            <div class="mt-4">
                <label class="block text-gray-700">Descrição</label>
                <textarea name="descricao" class="w-full p-2 border rounded" rows="4"></textarea>
            </div>
            <div class="mt-4">
                <label class="block text-gray-700">Dúvidas</label>
                <textarea name="duvidas" class="w-full p-2 border rounded" rows="2"></textarea>
            </div>
            <button type="submit" class="mt-4 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600"><i class="fas fa-save"></i> Salvar</button>
        </form>
    </div>
</body>
</html>