<?php
// models/Fatura.php

require_once __DIR__ . '/../config/database.php';

class Fatura {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function create($numero_fatura, $cliente_id, $os_id, $data_emissao, $descricao, $referencia, $periodo, $valor, $data_vencimento, $status, $duvidas) {
        $stmt = $this->pdo->prepare("INSERT INTO faturas (numero_fatura, cliente_id, os_id, data_emissao, descricao, referencia, periodo, valor, data_vencimento, status, duvidas) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return $stmt->execute([$numero_fatura, $cliente_id, $os_id, $data_emissao, $descricao, $referencia, $periodo, $valor, $data_vencimento, $status, $duvidas]);
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT f.*, c.nome AS cliente_nome, os.numero_os FROM faturas f JOIN clientes c ON f.cliente_id = c.id LEFT JOIN ordens_servico os ON f.os_id = os.id ORDER BY f.data_emissao DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT f.*, c.nome AS cliente_nome, os.numero_os FROM faturas f JOIN clientes c ON f.cliente_id = c.id LEFT JOIN ordens_servico os ON f.os_id = os.id WHERE f.id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function update($id, $numero_fatura, $cliente_id, $os_id, $data_emissao, $descricao, $referencia, $periodo, $valor, $data_vencimento, $status, $duvidas) {
        $stmt = $this->pdo->prepare("UPDATE faturas SET numero_fatura = ?, cliente_id = ?, os_id = ?, data_emissao = ?, descricao = ?, referencia = ?, periodo = ?, valor = ?, data_vencimento = ?, status = ?, duvidas = ? WHERE id = ?");
        return $stmt->execute([$numero_fatura, $cliente_id, $os_id, $data_emissao, $descricao, $referencia, $periodo, $valor, $data_vencimento, $status, $duvidas, $id]);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM faturas WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
?>