<?php
// controllers/OrdemServicoController.php

require_once __DIR__ . '/../models/OrdemServico.php';
require_once __DIR__ . '/../models/Cliente.php';

class OrdemServicoController {
    private $os;
    private $cliente;

    public function __construct($pdo) {
        $this->os = new OrdemServico($pdo);
        $this->cliente = new Cliente($pdo);
    }

    public function index() {
        $ordens = $this->os->getAll();
        require_once __DIR__ . '/../views/ordens_servico/listar.php';
    }

    public function create() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->os->create($_POST['numero_os'], $_POST['cliente_id'], $_POST['data_emissao'], $_POST['descricao'], $_POST['referencia'], $_POST['periodo'], $_POST['status'], $_POST['valor_estimado'] ?: null);
            header('Location: /public/index.php?page=os');
        } else {
            $clientes = $this->cliente->getAll();
            require_once __DIR__ . '/../views/ordens_servico/cadastrar.php';
        }
    }

    public function edit($id) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->os->update($id, $_POST['numero_os'], $_POST['cliente_id'], $_POST['data_emissao'], $_POST['descricao'], $_POST['referencia'], $_POST['periodo'], $_POST['status'], $_POST['valor_estimado'] ?: null);
            header('Location: /public/index.php?page=os');
        } else {
            $ordem = $this->os->getById($id);
            $clientes = $this->cliente->getAll();
            require_once __DIR__ . '/../views/ordens_servico/editar.php';
        }
    }

    public function delete($id) {
        $this->os->delete($id);
        header('Location: /public/index.php?page=os');
    }
}
?>