<?php
// controllers/FaturaController.php

require_once __DIR__ . '/../models/Fatura.php';
require_once __DIR__ . '/../models/Cliente.php';
require_once __DIR__ . '/../models/OrdemServico.php';

class FaturaController {
    private $fatura;
    private $cliente;
    private $os;

    public function __construct($pdo) {
        $this->fatura = new Fatura($pdo);
        $this->cliente = new Cliente($pdo);
        $this->os = new OrdemServico($pdo);
    }

    public function index() {
        $faturas = $this->fatura->getAll();
        require_once __DIR__ . '/../views/faturas/listar.php';
    }

    public function create() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->fatura->create($_POST['numero_fatura'], $_POST['cliente_id'], $_POST['os_id'] ?: null, $_POST['data_emissao'], $_POST['descricao'], $_POST['referencia'], $_POST['periodo'], $_POST['valor'], $_POST['data_vencimento'], $_POST['status'], $_POST['duvidas']);
            header('Location: /public/index.php?page=faturas');
        } else {
            $clientes = $this->cliente->getAll();
            $ordens = $this->os->getAll();
            require_once __DIR__ . '/../views/faturas/cadastrar.php';
        }
    }

    public function edit($id) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->fatura->update($id, $_POST['numero_fatura'], $_POST['cliente_id'], $_POST['os_id'] ?: null, $_POST['data_emissao'], $_POST['descricao'], $_POST['referencia'], $_POST['periodo'], $_POST['valor'], $_POST['data_vencimento'], $_POST['status'], $_POST['duvidas']);
            header('Location: /public/index.php?page=faturas');
        } else {
            $fatura = $this->fatura->getById($id);
            $clientes = $this->cliente->getAll();
            $ordens = $this->os->getAll();
            require_once __DIR__ . '/../views/faturas/editar.php';
        }
    }

    public function delete($id) {
        $this->fatura->delete($id);
        header('Location: /public/index.php?page=faturas');
    }
}
?>